# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 934-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56113);
 script_cve_id("CVE-2005-1391", "CVE-2005-3751");
 script_version ("$");
 name = "Debian Security Advisory DSA 934-1 (pound)";
 script_name(name);

 desc = "The remote host is missing an update to pound
announced via advisory DSA 934-1.

Two vulnerabilities have been discovered in Pound, a reverse proxy and
load balancer for HTTP. The Common Vulnerabilities and Exposures project
identifies the following problems:

* CVE-2005-1391:
Overly long HTTP Host: headers may trigger a buffer overflow in the
add_port() function, which may lead to the execution of arbitrary
code.

* CVE-2005-3751:
HTTP requests with conflicting Content-Length and Transfer-Encoding
headers could lead to HTTP Request Smuggling Attack, which can be
exploited to bypass packet filters or poison web caches.

The old stable distribution (woody) does not contain pound packages.

For the stable distribution (sarge) these problems have been fixed in
version 1.8.2-1sarge1

For the unstable distribution (sid) these problems have been fixed in
version 1.9.4-1

We recommend that you upgrade your pound package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20934-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 934-1 (pound)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"pound", ver:"1.8.2-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
