# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 918-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55973);
 script_cve_id("CVE-2005-3347", "CVE-2005-3533");
 script_version ("$");
 name = "Debian Security Advisory DSA 918-1 (osh)";
 script_name(name);

 desc = "The remote host is missing an update to osh
announced via advisory DSA 918-1.

Several security related problems have been discovered in osh, the
operator's shell for executing defined programs in a privileged
environment.  The Common Vulnerabilities and Exposures project
identifies the following vulnerabilities:

CVE-2005-3347

Charles Stevenson discovered a bug in the substitution of
variables that allows a local attacker to open a root shell.

CVE-2005-3533

Solar Eclipse discovered a buffer overflow caused by the current
working directory plus a filename that could be used to execute
arbitrary code and e.g. open a root shell.

For the old stable distribution (woody) these problems have been fixed in
version 1.7-11woody2.

For the stable distribution (sarge) these problems have been fixed in
version 1.7-13sarge1.

For the unstable distribution (sid) these problems have been fixed in
version 1.7-15, however, the package has been removed entirely.

We recommend that you upgrade your osh package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20918-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 918-1 (osh)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"osh", ver:"1.7-11woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"osh", ver:"1.7-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
