# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 897-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55877);
 script_cve_id("CVE-2005-0870", "CVE-2005-3347", "CVE-2005-3348");
 script_version ("$");
 name = "Debian Security Advisory DSA 897-1 (phpsysinfo)";
 script_name(name);

 desc = "The remote host is missing an update to phpsysinfo
announced via advisory DSA 897-1.

Several vulnerabilities have been discovered in phpsysinfo, a PHP
based host information application.  The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2005-0870

Maksymilian Arciemowicz discoverd several cross site scripting
problems, of which not all were fixed in DSA 724.

CVE-2005-3347

Christopher Kunz discovered that local variables get overwritten
unconditionally and are trusted later, which could lead to the
inclusion of arbitrary files.

CVE-2005-3348

Christopher Kunz discovered that user-supplied input is used
unsanitised, causing a HTTP Response splitting problem.

For the old stable distribution (woody) these problems have been fixed in
version 2.0-3woody3.

For the stable distribution (sarge) these problems have been fixed in
version 2.3-4sarge1.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you upgrade your phpsysinfo package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20897-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 897-1 (phpsysinfo)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"phpsysinfo", ver:"2.0-3woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpsysinfo", ver:"2.3-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
