# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 871-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55728);
 script_bugtraq_id(15200);
 script_cve_id("CVE-2005-2958");
 script_version ("$");
 name = "Debian Security Advisory DSA 871-1 (libgda2)";
 script_name(name);

 desc = "The remote host is missing an update to libgda2
announced via advisory DSA 871-1.

Steve Kemp discovered two format string vulnerabilities in libgda2,
the GNOME Data Access library for GNOME2, which may lead to the
execution of arbitrary code in programs that use this library.

The old stable distribution (woody) is not affected by these problems.

For the stable distribution (sarge) these problems have been fixed in
version 1.2.1-2sarge1.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you upgrade your libgda2 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20871-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 871-1 (libgda2)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"sudo", ver:"1.6.8p7-1.2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
