# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 868-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55711);
 script_cve_id("CVE-2005-2871", "CVE-2005-2701", "CVE-2005-2702", "CVE-2005-2703", "CVE-2005-2704", "CVE-2005-2705", "CVE-2005-2706", "CVE-2005-2707", "CVE-2005-2968");
 script_bugtraq_id(14784);
 script_version ("$");
 name = "Debian Security Advisory DSA 868-1 (mozilla-thunderbird)";
 script_name(name);

 desc = "The remote host is missing an update to mozilla-thunderbird
announced via advisory DSA 868-1.

Several security-related problems have been discovered in Mozilla and
derived programs.  Some of the problems don't exactly apply
to Mozilla Thunderbird, even though the code is present.  In order to
keep the codebase in sync with upstream it has been altered
nevertheless.  

For details on the problems, please visit the referenced security
advisories.

For the stable distribution (sarge) these problems have been fixed in
version 1.0.2-2.sarge1.0.7.

For the unstable distribution (sid) these problems have been fixed in
version 1.0.7-1.

We recommend that you upgrade your mozilla-thunderbird package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20868-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 868-1 (mozilla-thunderbird)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"1.0.2-2.sarge1.0.7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"1.0.2-2.sarge1.0.7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-inspector", ver:"1.0.2-2.sarge1.0.7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-offline", ver:"1.0.2-2.sarge1.0.7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-typeaheadfind", ver:"1.0.2-2.sarge1.0.7", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
