# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 823-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55486);
 script_bugtraq_id(14816);
 script_cve_id("CVE-2005-2876");
 script_version ("$");
 name = "Debian Security Advisory DSA 823-1 (util-linux)";
 script_name(name);

 desc = "The remote host is missing an update to util-linux
announced via advisory DSA 823-1.

David Watson discoverd a bug in mount as provided by util-linux and
other packages such as loop-aes-utils that allows local users to
bypass filesystem access restrictions by re-mounting it read-only.

For the old stable distribution (woody) this problem has been fixed in
version 2.11n-7woody1.

For the stable distribution (sarge) this problem has been fixed in
version 2.12p-4sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 2.12p-8.

We recommend that you upgrade your loop-aes-utils package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20823-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 823-1 (util-linux)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"util-linux-locales", ver:"2.11n-7woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bsdutils", ver:"2.11n-7woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mount", ver:"2.11n-7woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"util-linux", ver:"2.11n-7woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"util-linux-locales", ver:"2.12p-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bsdutils", ver:"2.12p-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mount", ver:"2.12p-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"util-linux", ver:"2.12p-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
