# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 814-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55336);
 script_bugtraq_id(14624);
 script_cve_id("CVE-2005-2672");
 script_version ("$");
 name = "Debian Security Advisory DSA 814-1 (lm-sensors)";
 script_name(name);

 desc = "The remote host is missing an update to lm-sensors
announced via advisory DSA 814-1.

Javier Fernandez-Sanguino Pena discovered that a script of lm-sensors,
utilities to read temperature/voltage/fan sensors, creates a temporary
file with a predictable filename, leaving it vulnerable for a symlink
attack.

The old stable distribution (woody) is not affected by this problem.

For the stable distribution (sarge) this problem has been fixed in
version 2.9.1-1sarge2.

For the unstable distribution (sid) this problem has been fixed in
version 2.9.1-7.

We recommend that you upgrade your lm-sensors package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20814-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 814-1 (lm-sensors)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kernel-patch-2.4-lm-sensors", ver:"2.9.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lm-sensors-source", ver:"2.9.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsensors-dev", ver:"2.9.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsensors3", ver:"2.9.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lm-sensors", ver:"2.9.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sensord", ver:"2.9.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lm-sensors-2.4.27-2-386", ver:"2.9.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lm-sensors-2.4.27-2-586tsc", ver:"2.9.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lm-sensors-2.4.27-2-686", ver:"2.9.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lm-sensors-2.4.27-2-686-smp", ver:"2.9.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lm-sensors-2.4.27-2-k6", ver:"2.9.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lm-sensors-2.4.27-2-k7", ver:"2.9.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lm-sensors-2.4.27-2-k7-smp", ver:"2.9.1-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
