# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 798-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55208);
 script_cve_id("CVE-2005-2498", "CVE-2005-2600", "CVE-2005-2761");
 script_version ("$");
 name = "Debian Security Advisory DSA 798-1 (phpgroupware)";
 script_name(name);

 desc = "The remote host is missing an update to phpgroupware
announced via advisory DSA 798-1.

Several vulnerabilities have been discovered in phpgroupware, a web
based groupware system written in PHP.  The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2005-2498

Stefan Esser discovered another vulnerability in the XML-RPC
libraries that allows injection of arbitrary PHP code into eval()
statements.  The XMLRPC component has been disabled.

CVE-2005-2600

Alexander Heidenreich discovered a cross-site scriptiong problem
in the tree view of FUD Forum Bulletin Board Software, which is
also present in phpgroupware.

CVE-2005-2761

A global cross-site scripting fix has also been included that
protects against potential malicious scripts embedded in CSS and
xmlns in various parts of the application and modules.

This update also contains a postinst bugfix that has been approved for
the next update to the stable release.

For the old stable distribution (woody) these problems don't apply.

For the stable distribution (sarge) these problems have been fixed in
version 0.9.16.005-3.sarge2.

For the unstable distribution (sid) these problems have been fixed in
version 0.9.16.008.

We recommend that you upgrade your phpgroupware packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20798-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 798-1 (phpgroupware)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"phpgroupware-addressbook", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-admin", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-bookmarks", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-calendar", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-chat", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-comic", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-core", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-developer-tools", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-dj", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-eldaptir", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-email", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-etemplate", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-felamimail", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-filemanager", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-folders", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-forum", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-ftp", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-fudforum", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-headlines", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-hr", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-img", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-infolog", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-manual", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-messenger", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-news-admin", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-nntp", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-notes", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-phonelog", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-phpbrain", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-phpgwapi", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-phpsysinfo", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-polls", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-preferences", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-projects", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-qmailldap", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-registration", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-setup", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-sitemgr", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-skel", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-soap", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-stocks", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-todo", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-tts", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-wiki", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-xmlrpc", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware", ver:"0.9.16.005-3.sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
