# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 793-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55204);
 script_bugtraq_id(14650);
 script_cve_id("CVE-2005-2724");
 script_version ("$");
 name = "Debian Security Advisory DSA 793-1 (courier)";
 script_name(name);

 desc = "The remote host is missing an update to courier
announced via advisory DSA 793-1.

Jakob Balle discovered a vulnerability in the handling of attachments
in sqwebmail, a web mail application provided by the courier mail
suite, which can be exploited by an attacker to conduct script
insertion attacks.

For the old stable distribution (woody) this problem has been fixed in
version 0.37.3-2.6.

For the stable distribution (sarge) this problem has been fixed in
version 0.47-4sarge2.

For the unstable distribution (sid) this problem has been fixed in
version 0.47-8.

We recommend that you upgrade your sqwebmail package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20793-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 793-1 (courier)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"courier-doc", ver:"0.37.3-2.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-authdaemon", ver:"0.37.3-2.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-authmysql", ver:"0.37.3-2.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-base", ver:"0.37.3-2.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-debug", ver:"0.37.3-2.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-imap", ver:"1.4.3-2.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-ldap", ver:"0.37.3-2.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-maildrop", ver:"0.37.3-2.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-mlm", ver:"0.37.3-2.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-mta", ver:"0.37.3-2.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-pcp", ver:"0.37.3-2.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-pop", ver:"0.37.3-2.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-webadmin", ver:"0.37.3-2.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sqwebmail", ver:"0.37.3-2.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-doc", ver:"0.47-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-authdaemon", ver:"0.47-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-authmysql", ver:"0.47-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-authpostgresql", ver:"0.47-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-base", ver:"0.47-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-faxmail", ver:"0.47-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-imap", ver:"3.0.8-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-imap-ssl", ver:"3.0.8-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-ldap", ver:"0.47-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-maildrop", ver:"0.47-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-mlm", ver:"0.47-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-mta", ver:"0.47-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-mta-ssl", ver:"0.47-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-pcp", ver:"0.47-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-pop", ver:"0.47-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-pop-ssl", ver:"0.47-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-ssl", ver:"0.47-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-webadmin", ver:"0.47-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sqwebmail", ver:"0.47-4sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
