# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 756-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54348);
 script_cve_id("CVE-2005-1769", "CVE-2005-2095");
 script_version ("$");
 name = "Debian Security Advisory DSA 756-1 (squirrelmail)";
 script_name(name);

 desc = "The remote host is missing an update to squirrelmail
announced via advisory DSA 756-1.

Several vulnerabilities have been discovered in Squirrelmail, a
commonly used webmail system.  The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2005-1769

Martijn Brinkers discovered cross-site scripting vulnerabilities
that allow remote attackers to inject arbitrary web script or HTML
in the URL and e-mail messages.

CVE-2005-2095

James Bercegay of GulfTech Security discovered a vulnerability in
the variable handling which could lead to attackers altering other
people's preferences and possibly reading them, writing files at
any location writable for www-data and cross site scripting.

For the old stable distribution (woody) these problems have been fixed in
version 1.2.6-4.

For the stable distribution (sarge) these problems have been fixed in
version 1.4.4-6sarge1.

For the unstable distribution (sid) these problems have been fixed in
version 1.4.4-6sarge1.

We recommend that you upgrade your squirrelmail package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20756-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 756-1 (squirrelmail)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"squirrelmail", ver:"1.2.6-4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squirrelmail", ver:"1.4.4-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
