# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 751-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54318);
 script_bugtraq_id(13592);
 script_cve_id("CVE-2005-1519");
 script_version ("$");
 name = "Debian Security Advisory DSA 751-1 (squid)";
 script_name(name);

 desc = "The remote host is missing an update to squid
announced via advisory DSA 751-1.

The upstream developers have discovered a bug in the DNS lookup code
of Squid, the popular WWW proxy cache.  When the DNS client UDP port
(assigned by the operating system at startup) is unfiltered and the
network is not protected from IP spoofing, malicious users can spoof
DNS lookups which could result in users being redirected to arbitrary
web sites.

For the old stable distribution (woody) this problem has been fixed in
version 2.4.6-2woody9.

For the stable distribution (sarge) this problem has already been
fixed in version squid-2.5.9-9.

For the unstable distribution (sid) this problem has already been
fixed in version squid-2.5.9-9.

We recommend that you upgrade your squid package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20751-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 751-1 (squid)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"squid", ver:"2.4.6-2woody9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid-cgi", ver:"2.4.6-2woody9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squidclient", ver:"2.4.6-2woody9", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
