# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 745-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54323);
 script_cve_id("CVE-2005-1921", "CVE-2005-2106", "CVE-2005-2116");
 script_version ("$");
 name = "Debian Security Advisory DSA 745-1 (drupal)";
 script_name(name);

 desc = "The remote host is missing an update to drupal
announced via advisory DSA 745-1.

Two input validation errors were discovered in drupal and its bundled
xmlrpc module. These errors can lead to the execution of arbitrary
commands on the web server running drupal.

drupal was not included in the old stable distribution (woody).

For the current stable distribution (sarge), these problems have been
fixed in version 4.5.3-3.

For the unstable distribution (sid), these problems have been fixed in
version 4.5.4-1.

We recommend that you upgrade your drupal package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20745-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 745-1 (drupal)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"drupal", ver:"4.5.3-3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
