# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 711-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53537);
 script_cve_id("CVE-2004-1341");
 script_version ("$");
 name = "Debian Security Advisory DSA 711-1 (info2www)";
 script_name(name);

 desc = "The remote host is missing an update to info2www
announced via advisory DSA 711-1.

Nicolas Gregoire discovered a cross-site scripting vulnerability in
info2www, a converter for info files to HTML.  A malicious person
could place a harmless looking link on the web that could cause
arbitrary commands to be executed in the browser of the victim user.

For the stable distribution (woody) this problem has been fixed in
version 1.2.2.9-20woody1.

For the unstable distribution (sid) this problem has been fixed in
version 1.2.2.9-23.

We recommend that you upgrade your info2www package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20711-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 711-1 (info2www)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"info2www", ver:"1.2.2.9-20woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
