# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 704-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53533);
 script_cve_id("CVE-2005-0387", "CVE-2005-0388");
 script_version ("$");
 name = "Debian Security Advisory DSA 704-1 (remstats)";
 script_name(name);

 desc = "The remote host is missing an update to remstats
announced via advisory DSA 704-1.

Jens Steube discovered several vulnerabilities in remstats, the remote
statistics system.  The Common Vulnerabilities and Exposures Project
identifies the following problems:

CVE-2005-0387

When processing uptime data on the unix-server a temporary file is
opened in an insecure fashion which could be used for a symlink
attack to create or overwrite arbitrary files with the permissions
of the remstats user.

CVE-2005-0388

The remoteping service can be exploited to execute arbitrary
commands due to missing input sanitising.

For the stable distribution (woody) these problems have been fixed in
version 1.00a4-8woody1.

For the unstable distribution (sid) these problems have been fixed in
version 1.0.13a-5.

We recommend that you upgrade your remstats packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20704-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 704-1 (remstats)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"remstats-doc", ver:"1.00a4-8woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"remstats-servers", ver:"1.00a4-8woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"remstats", ver:"1.00a4-8woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"remstats-bintools", ver:"1.00a4-8woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
