# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 647-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53481);
 script_bugtraq_id(12277);
 script_cve_id("CVE-2005-0004");
 script_version ("$");
 name = "Debian Security Advisory DSA 647-1 (mysql)";
 script_name(name);

 desc = "The remote host is missing an update to mysql
announced via advisory DSA 647-1.

Javier Fernandez-Sanguino Pena from the Debian Security Audit Project
discoverd a temporary file vulnerability in the mysqlaccess script of
MySQL that could allow an unprivileged user to let root overwrite
arbitrary files via a symlink attack and could also could unveil the
contents of a temporary file which might contain sensitive
information.

For the stable distribution (woody) this problem has been fixed in
version 3.23.49-8.9.

For the unstable distribution (sid) this problem has been fixed in
version 4.0.23-3 of mysql-dfsg and in version 4.1.8a-6 of
mysql-dfsg-4.1.

We recommend that you upgrade your mysql packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20647-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 647-1 (mysql)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mysql-common", ver:"3.23.49-8.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-doc", ver:"3.23.49-8.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient10", ver:"3.23.49-8.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient10-dev", ver:"3.23.49-8.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-client", ver:"3.23.49-8.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server", ver:"3.23.49-8.9", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
