# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 639-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53475);
 script_cve_id("CVE-2004-1004", "CVE-2004-1005", "CVE-2004-1009", "CVE-2004-1090", "CVE-2004-1091", "CVE-2004-1092", "CVE-2004-1093", "CVE-2004-1174", "CVE-2004-1175", "CVE-2004-1176");
 script_version ("$");
 name = "Debian Security Advisory DSA 639-1 (mc)";
 script_name(name);

 desc = "The remote host is missing an update to mc
announced via advisory DSA 639-1.

Andrew V. Samoilov has noticed that several bugfixes which were
applied to the source by upstream developers of mc, the midnight
commander, a file browser and manager, were not backported to the
current version of mc that Debian ships in their stable release.  The
Common Vulnerabilities and Exposures Project identifies the following
vulnerabilities:

CVE-2004-1004: Multiple format string vulnerabilities
CVE-2004-1005: Multiple buffer overflows
CVE-2004-1009: One infinite loop vulnerability
CVE-2004-1090: Denial of service via  corrupted section header
CVE-2004-1091: Denial of service via null dereference
CVE-2004-1092: Freeing unallocated memory
CVE-2004-1093: Denial of service via use of already freed memory
CVE-2004-1174: Denial of service via manipulating non-existing file handles
CVE-2004-1175: Unintended program execution via insecure filename quoting
CVE-2004-1176: Denial of service via a buffer underflow

For the stable distribution (woody) these problems have been fixed in
version 4.5.55-1.2woody5

For the unstable distribution (sid) these problems should already be
fixed since they were backported from current versions.

We recommend that you upgrade your mc package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20639-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 639-1 (mc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gmc", ver:"4.5.55-1.2woody5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mc", ver:"4.5.55-1.2woody5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mc-common", ver:"4.5.55-1.2woody5", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
