# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 634-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53470);
 script_cve_id("CVE-2004-1182");
 script_version ("$");
 name = "Debian Security Advisory DSA 634-1 (hylafax)";
 script_name(name);

 desc = "The remote host is missing an update to hylafax
announced via advisory DSA 634-1.

Patrice Fournier discovered a vulnerability in the authorisation
subsystem of hylafax, a flexible client/server fax system.  A local or
remote user guessing the contents of the hosts.hfaxd database could
gain unauthorised access to the fax system.

Some installations of hylafax may actually utilise the weak hostname
and username validation for authorized uses.  For example, hosts.hfaxd
entries that may be common are

192.168.0
username:uid:pass:adminpass
user@host

After updating, these entries will need to be modified in order to
continue to function.  Respectively, the correct entries should be

192.168.0.[0-9]+
username@:uid:pass:adminpass
user@host

Unless such maching of username with otherusername and host with
hostname is desired, the proper form of these entries should include
the delimiter and markers like this

@192.168.0.[0-9]+$
^username@:uid:pass:adminpass
^user@host$

For the stable distribution (woody) this problem has been fixed in
version 4.1.1-3.1.

For the unstable distribution (sid) this problem has been fixed in
version 4.2.1-1.

We recommend that you upgrade your hylafax packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20634-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 634-1 (hylafax)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"hylafax-doc", ver:"4.1.1-3.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"hylafax-client", ver:"4.1.1-3.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"hylafax-server", ver:"4.1.1-3.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
