# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 628-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53466);
 script_cve_id("CVE-2004-1026", "CVE-2004-1025");
 script_version ("$");
 name = "Debian Security Advisory DSA 628-1 (imlib2)";
 script_name(name);

 desc = "The remote host is missing an update to imlib2
announced via advisory DSA 628-1.

Pavel Kankovsky discovered that several overflows found in the libXpm
library were also present in imlib and imlib2, imaging libraries for
X11.  An attacker could create a carefully crafted image file in such
a way that it could cause an application linked with imlib or imlib2
to execute arbitrary code when the file was opened by a victim.  The
Common Vulnerabilities and Exposures project identifies the following
problems:

CVE-2004-1025

Multiple heap-based buffer overflows.  No such code is present in
imlib2.

CVE-2004-1026

Multiple integer overflows in the imlib library.

For the stable distribution (woody) these problems have been fixed in
version 1.0.5-2woody2.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you upgrade your imlib2 packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20628-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 628-1 (imlib2)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libimlib2", ver:"1.0.5-2woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libimlib2-dev", ver:"1.0.5-2woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
