# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 608-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53715);
 script_cve_id("CVE-2004-1095", "CVE-2004-0999");
 script_bugtraq_id(11556);
 script_version ("$");
 name = "Debian Security Advisory DSA 608-1 (zgv)";
 script_name(name);

 desc = "The remote host is missing an update to zgv
announced via advisory DSA 608-1.

Several vulnerabilities have been discovered in zgv, an SVGAlib
graphics viewer for the i386 architecture.  The Common Vulnerabilities
and Exposures Project identifies the following problems:

CVE-2004-1095

Luke Macken and infamous41md independently discoverd multiple
integer overflows in zgv.  Remote exploitation of an integer
overflow vulnerability could allow the execution of arbitrary
code.

CVE-2004-0999

Mikulas Patocka discovered that malicious multiple-image (e.g.
animated) GIF images can cause a segmentation fault in zgv.

For the stable distribution (woody) these problems have been fixed in
version 5.5-3woody1.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you upgrade your zgv package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20608-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 608-1 (zgv)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"zgv", ver:"5.5-3woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
