# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 549-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53690);
 script_cve_id("CVE-2004-0782", "CVE-2004-0783", "CVE-2004-0788");
 script_version ("$");
 name = "Debian Security Advisory DSA 549-1 (gtk+2.0)";
 script_name(name);

 desc = "The remote host is missing an update to gtk+2.0
announced via advisory DSA 549-1.

Chris Evans discovered several problems in gdk-pixbuf, the GdkPixBuf
library used in Gtk.  It is possible for an attacker to execute
arbitrary code on the victims machine.  Gdk-pixbuf for Gtk+1.2 is an
external package.  For Gtk+2.0 it's part of the main gtk package.

The Common Vulnerabilities and Exposures Project identifies the
following vulnerabilities:

CVE-2004-0782

Heap-based overflow in pixbuf_create_from_xpm.

CVE-2004-0783

Stack-based overflow in xpm_extract_color.

CVE-2004-0788

Integer overflow in the ico loader.

For the stable distribution (woody) these problems have been fixed in
version 2.0.2-5woody2.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you upgrade your Gtk packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20549-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 549-1 (gtk+2.0)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libgtk2.0-doc", ver:"2.0.2-5woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gtk2.0-examples", ver:"2.0.2-5woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgtk-common", ver:"2.0.2-5woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgtk2.0-0", ver:"2.0.2-5woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgtk2.0-common", ver:"2.0.2-5woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgtk2.0-dbg", ver:"2.0.2-5woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgtk2.0-dev", ver:"2.0.2-5woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
