# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 536-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53226);
 script_cve_id("CVE-2004-0597", "CVE-2004-0598", "CVE-2004-0599", "CVE-2004-0768", "CVE-2002-1363");
 script_version ("$");
 name = "Debian Security Advisory DSA 536-1 (libpng)";
 script_name(name);

 desc = "The remote host is missing an update to libpng
announced via advisory DSA 536-1.

Chris Evans discovered several vulnerabilities in libpng:

CVE-2004-0597 - Multiple buffer overflows exist, including when
handling transparency chunk data, which could be exploited to cause
arbitrary code to be executed when a specially crafted PNG image is
processed

CVE-2004-0598 - Multiple NULL pointer dereferences in
png_handle_iCPP() and elsewhere could be exploited to cause an
application to crash when a specially crafted PNG image is processed

CVE-2004-0599 - Multiple integer overflows in png_handle_sPLT(),
png_read_png() nctions and elsewhere could be exploited to cause an
application to crash, or potentially arbitrary code to be executed,
when a specially crafted PNG image is processed

In addition, a bug related to CVE-2002-1363 was fixed:

CVE-2004-0768 - A buffer overflow could be caused by incorrect
calculation of buffer offsets, possibly leading to the execution of
arbitrary code

For the current stable distribution (woody), these problems have been
fixed in libpng3 version 1.2.1-1.1.woody.7 and libpng version
1.0.12-3.woody.7.

For the unstable distribution (sid), these problems will be fixed soon.

We recommend that you update your libpng and libpng3 packages.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20536-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 536-1 (libpng)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libpng2", ver:"1.0.12-3.woody.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng2-dev", ver:"1.0.12-3.woody.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng-dev", ver:"1.2.1-1.1.woody.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng3", ver:"1.2.1-1.1.woody.7", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
