# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 534-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53223);
 script_bugtraq_id(6055);
 script_cve_id("CVE-2002-1581");
 script_version ("$");
 name = "Debian Security Advisory DSA 534-1 (mailreader)";
 script_name(name);

 desc = "The remote host is missing an update to mailreader
announced via advisory DSA 534-1.

A directory traversal vulnerability was discovered in mailreader
whereby remote attackers could view arbitrary files with the
privileges of the nph-mr.cgi process (by default, www-data) via
relative paths and a null byte in the configLanguage parameter.

For the current stable distribution (woody), this problem has been
fixed in version 2.3.29-5woody1.

For the unstable distribution (sid), this problem will be fixed soon.

We recommend that you update your mailreader package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20534-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 534-1 (mailreader)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mailreader", ver:"2.3.29-5woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
