# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 486-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53177);
 script_cve_id("CVE-2004-0180", "CVE-2004-0405");
 script_version ("$");
 name = "Debian Security Advisory DSA 486-1 (cvs)";
 script_name(name);

 desc = "The remote host is missing an update to cvs
announced via advisory DSA 486-1.

Two vulnerabilities have been discovered and fixed in CVS:

CVE-2004-0180 - Sebastian Krahmer discovered a vulnerability whereby
a malicious CVS pserver could create arbitary files on the client
system during an update or checkout operation, by supplying absolute
pathnames in RCS diffs.

CVE-2004-0405 - Derek Robert Price discovered a vulnerability whereby
a CVS pserver could be abused by a malicious client to view the
contents of certain files outside of the CVS root directory using
relative pathnames containing ../.

For the current stable distribution (woody) these problems have been
fixed in version 1.11.1p1debian-9woody2.

For the unstable distribution (sid), these problems will be fixed soon.

We recommend that you update your cvs package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20486-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 486-1 (cvs)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cvs", ver:"1.11.1p1debian-9woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
