# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 483-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53755);
 script_cve_id("CVE-2004-0381", "CVE-2004-0388");
 script_bugtraq_id(9976);
 script_version ("$");
 name = "Debian Security Advisory DSA 483-1 (mysql)";
 script_name(name);

 desc = "The remote host is missing an update to mysql
announced via advisory DSA 483-1.

Two vulnerabilities have been discovered in mysql, a common database
system.  Two scripts contained in the package don't create temporary
files in a secure fashion.  This could allow a local attacker to
overwrite files with the privileges of the user invoking the MySQL
server, which is often the root user.  The Common Vulnerabilities and
Exposures identifies the following problems:

CVE-2004-0381

The script mysqlbug in MySQL allows local users to overwrite
arbitrary files via a symlink attack.

CVE-2004-0388

The script mysqld_multi in MySQL allows local users to overwrite
arbitrary files via a symlink attack.

For the stable distribution (woody) these problems have been fixed in
version 3.23.49-8.6.

For the unstable distribution (sid) these problems will be fixed in
version 4.0.18-6 of mysql-dfsg.

We recommend that you upgrade your mysql, mysql-dfsg and related


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20483-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 483-1 (mysql)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mysql-common", ver:"3.23.49-8.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient10", ver:"3.23.49-8.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient10-dev", ver:"3.23.49-8.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-client", ver:"3.23.49-8.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server", ver:"3.23.49-8.6", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
