# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 432-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53131);
 script_bugtraq_id(9566);
 script_cve_id("CVE-2004-0103");
 script_version ("$");
 name = "Debian Security Advisory DSA 432-1 (crawl)";
 script_name(name);

 desc = "The remote host is missing an update to crawl
announced via advisory DSA 432-1.

Steve Kemp from the GNU/Linux audit project discovered a problem in
crawl, another console based dungeon exploration game, in the vein of
nethack and rogue.  The program uses several environment variables as
inputs but doesn't apply a size check before copying one of them into
a fixed size buffer.

For the stable distribution (woody) this problem has been fixed in
version 4.0.0beta23-2woody1.

For the unstable distribution (sid) this problem has been fixed in
version 4.0.0beta26-4.

We recommend that you upgrade your crawl package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20432-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 432-1 (crawl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"crawl", ver:"4.0.0beta23-2woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
