# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 426-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53124);
 script_bugtraq_id(9442);
 script_cve_id("CVE-2003-0924");
 script_version ("$");
 name = "Debian Security Advisory DSA 426-1 (netpbm-free)";
 script_name(name);

 desc = "The remote host is missing an update to netpbm-free
announced via advisory DSA 426-1.

netpbm is graphics conversion toolkit made up of a large number of
single-purpose programs.  Many of these programs were found to create
temporary files in an insecure manner, which could allow a local
attacker to overwrite files with the privileges of the user invoking a
vulnerable netpbm tool.

For the current stable distribution (woody) these problems have been
fixed in version 2:9.20-8.4.

For the unstable distribution (sid) these problems have been fixed in
version 2:9.25-9.

We recommend that you update your netpbm-free package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20426-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 426-1 (netpbm-free)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libnetpbm9", ver:"9.20-8.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnetpbm9-dev", ver:"9.20-8.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"netpbm", ver:"9.20-8.4", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
