# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 417-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53114);
 script_bugtraq_id(9356);
 script_cve_id("CVE-2003-0985");
 script_version ("$");
 name = "Debian Security Advisory DSA 417-1 (kernel-patch-2.4.18-powerpc, kernel-image-2.4.18-1-alpha)";
 script_name(name);

 desc = "The remote host is missing an update to kernel-patch-2.4.18-powerpc, kernel-image-2.4.18-1-alpha
announced via advisory DSA 417-1.

Paul Starzetz discovered a flaw in bounds checking in mremap() in the
Linux kernel (present in version 2.4.x and 2.6.x) which may allow a
local attacker to gain root privileges.  Version 2.2 is not affected
by this bug.

For the stable distribution (woody) this problem has been fixed in
version 2.4.18-1woody3 for the powerpc architecture.

For the unstable distribution (sid) this problem will be fixed soon
with newly uploaded packages.

We recommend that you upgrade your kernel packages.  This problem has


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20417-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 417-1 (kernel-patch-2.4.18-powerpc, kernel-image-2.4.18-1-alpha)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kernel-doc-2.4.18", ver:"2.4.18-14.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-source-2.4.18", ver:"2.4.18-14.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-patch-2.4.18-powerpc", ver:"2.4.18-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.18-1", ver:"2.4.18-12", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.18-1-generic", ver:"2.4.18-12", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.18-1-smp", ver:"2.4.18-12", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.18-1-generic", ver:"2.4.18-11", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.18-1-smp", ver:"2.4.18-11", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.18", ver:"2.4.18-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.18-newpmac", ver:"2.4.18-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.18-powerpc", ver:"2.4.18-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.18-powerpc-smp", ver:"2.4.18-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
