# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 337-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53626);
 script_cve_id("CVE-2003-0440");
 script_version ("$");
 name = "Debian Security Advisory DSA 337-1 (semi, wemi)";
 script_name(name);

 desc = "The remote host is missing an update to semi, wemi
announced via advisory DSA 337-1.

semi, a MIME library for GNU Emacs, does not take appropriate
security precautions when creating temporary files.  This bug could
potentially be exploited to overwrite arbitrary files with the
privileges of the user running Emacs and semi, potentially with
contents supplied by the attacker.

wemi is a fork of semi, and contains the same bug.

For the stable distribution (woody) this problem has been fixed in
semi version 1.14.3.cvs.2001.08.10-1woody2 and wemi version
1.14.0.20010802wemiko-1.3.

For the unstable distribution (sid) this problem has been fixed in
semi version 1.14.5+20030609-1.  The unstable distribution does not
contain a wemi package.

We recommend that you update your semi and wemi packages.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20337-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 337-1 (semi, wemi)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"semi", ver:"1.14.3.cvs.2001.08.10-1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wemi", ver:"1.14.0.20010802wemiko-1.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
