# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 286-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53355);
 script_version ("$");
 name = "Debian Security Advisory DSA 286-1 (gs-common)";
 script_name(name);

 desc = "The remote host is missing an update to gs-common
announced via advisory DSA 286-1.

Paul Szabo discovered insecure creation of a temporary file in
ps2epsi, a script that is distributed as part of gs-common which
contains common files for different Ghostscript releases.  ps2epsiuses
a temporary file in the process of invoking ghostscript.  This file
was created in an insecure fashion, which could allow a local attacker
to overwrite files owned by a user who invokes ps2epsi.

For the stable distribution (woody) this problem has been fixed in
version 0.3.3.0woody1.

The old stable distribution (potato) is not affected by this problem.

For the unstable distribution (sid) these problems have been fixed in
version 0.3.3.1.

We recommend that you upgrade your gs-common package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20286-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 286-1 (gs-common)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gs-common", ver:"0.3.3.0woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
