# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 265-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53336);
 script_cve_id("CVE-2003-0152", "CVE-2003-0153", "CVE-2003-0154", "CVE-2003-0155");
 script_version ("$");
 name = "Debian Security Advisory DSA 265-1 (bonsai)";
 script_name(name);

 desc = "The remote host is missing an update to bonsai
announced via advisory DSA 265-1.

Rmi Perrot fixed several security related bugs in the bonsai, the
Mozilla CVS query tool by web interface.  Vulnerabilities include
arbitrary code execution, cross-site scripting and access to
configuration parameters.  The Common Vulnerabilities and Exposures
project identifies the following problems:

* CVE-2003-0152 - Remote execution of arbitrary commands as www-data

* CVE-2003-0153 - Absolute path disclosure

* CVE-2003-0154 - Cross site scriptiong attacks

* CVE-2003-0155 - Unauthenticated access to parameters page

For the stable distribution (woody) these problems have been fixed in
version 1.3+cvs20020224-1woody1.

The old stable distribution (potato) is not affected since it doesn't
contain bonsai.

For the unstable distribution (sid) these problems have been fixed in
version 1.3+cvs20030317-1.

We recommend that you upgrade your bonsai package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20265-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 265-1 (bonsai)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"bonsai", ver:"1.3+cvs20020224-1woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
