# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 260-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53591);
 script_cve_id("CVE-2003-0102");
 script_version ("$");
 name = "Debian Security Advisory DSA 260-1 (file)";
 script_name(name);

 desc = "The remote host is missing an update to file
announced via advisory DSA 260-1.

iDEFENSE discovered a buffer overflow vulnerability in the ELF format
parsing of the 'file' command, one which can be used to execute
arbitrary code with the privileges of the user running the command. The
vulnerability can be exploited by crafting a special ELF binary which is
then input to file. This could be accomplished by leaving the binary on
the file system and waiting for someone to use file to identify it, or
by passing it to a service that uses file to classify input. (For
example, some printer filters run file to determine how to process input
going to a printer.)

Fixed packages are available in version 3.28-1.potato.1 for Debian 2.2
(potato) and version 3.37-3.1.woody.1 for Debian 3.0 (woody). We
recommend you upgrade your file package immediately.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20260-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 260-1 (file)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"file", ver:"3.28-1.potato.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"file", ver:"3.37-3.1.woody.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
