# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1947-1 (shibboleth-sp, shibboleth-sp2, opensaml2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66514);
 script_cve_id("CVE-2009-3300");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1947-1 (shibboleth-sp, shibboleth-sp2, opensaml2)");

 desc = "The remote host is missing an update to shibboleth-sp, shibboleth-sp2, opensaml2
announced via advisory DSA 1947-1.

Matt Elder discovered that Shibboleth, a federated web single sign-on
system is vulnerable to script injection through redirection URLs. More
details can be found in the Shibboleth advisory at
http://shibboleth.internet2.edu/secadv/secadv_20091104.txt

For the old stable distribution (etch), this problem has been fixed in
version 1.3f.dfsg1-2+etch2 of shibboleth-sp.

For the stable distribution (lenny), this problem has been fixed in
version 1.3.1.dfsg1-3+lenny2 of shibboleth-sp, version 2.0.dfsg1-4+lenny2
of shibboleth-sp2 and version 2.0-2+lenny2 of opensaml2.

For the unstable distribution (sid), this problem has been fixed in
version 2.3+dfsg-1 of shibboleth-sp2, version 2.3-1 of opensaml2 and
version 1.3.1-1 of xmltooling.

We recommend that you upgrade your Shibboleth packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201947-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1947-1 (shibboleth-sp, shibboleth-sp2, opensaml2)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libshib-dev", ver:"1.3f.dfsg1-2+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libshib-target5", ver:"1.3f.dfsg1-2+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libshib6", ver:"1.3f.dfsg1-2+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-shib", ver:"1.3f.dfsg1-2+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsaml2-doc", ver:"2.0-2+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"opensaml2-schemas", ver:"2.0-2+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libshibsp-doc", ver:"2.0.dfsg1-4+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"shibboleth-sp2-schemas", ver:"2.0.dfsg1-4+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libshib-dev", ver:"1.3.1.dfsg1-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libshib6", ver:"1.3.1.dfsg1-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libshib-target5", ver:"1.3.1.dfsg1-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-shib", ver:"1.3.1.dfsg1-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-shib2", ver:"2.0.dfsg1-4+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libshibsp1", ver:"2.0.dfsg1-4+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libshibsp-dev", ver:"2.0.dfsg1-4+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsaml2-dev", ver:"2.0-2+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"opensaml2-tools", ver:"2.0-2+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsaml2", ver:"2.0-2+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
