# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1939-1 (libvorbis)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66331);
 script_cve_id("CVE-2009-2663", "CVE-2009-3379");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1939-1 (libvorbis)");

 desc = "The remote host is missing an update to libvorbis
announced via advisory DSA 1939-1.

Lucas Adamski, Matthew Gregan, David Keeler, and Dan Kaminsky discovered
that libvorbis, a library for the Vorbis general-purpose compressed
audio codec, did not correctly handle certain malformed ogg files. An
attacher could cause a denial of service (memory corruption and
application crash) or possibly execute arbitrary code via a crafted .ogg
file.

For the oldstable distribution (etch), these problems have been fixed in
version 1.1.2.dfsg-1.4+etch1.

For the stable distribution (lenny), these problems have been fixed in
version 1.2.0.dfsg-3.1+lenny1.

For the testing distribution (squeeze) and the unstable distribution
(sid), these problems have been fixed in version 1.2.3-1

We recommend that you upgrade your libvorbis packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201939-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1939-1 (libvorbis)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libvorbisenc2", ver:"1.1.2.dfsg-1.4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbisfile3", ver:"1.1.2.dfsg-1.4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbis0a", ver:"1.1.2.dfsg-1.4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbis-dev", ver:"1.1.2.dfsg-1.4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbisfile3", ver:"1.2.0.dfsg-3.1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbis0a", ver:"1.2.0.dfsg-3.1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbis-dev", ver:"1.2.0.dfsg-3.1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbisenc2", ver:"1.2.0.dfsg-3.1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
