# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1927-1 (linux-2.6)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66207);
 script_cve_id("CVE-2009-3228", "CVE-2009-3238", "CVE-2009-3547", "CVE-2009-3612", "CVE-2009-3620", "CVE-2009-3621", "CVE-2009-3638");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1927-1 (linux-2.6)");

 desc = "The remote host is missing an update to linux-2.6
announced via advisory DSA 1927-1.

Notice: Debian 5.0.4, the next point release of Debian 'lenny', will
include a new default value for the mmap_min_addr tunable.  This
change will add an additional safeguard against a class of security
vulnerabilities known as NULL pointer dereference vulnerabilities,
but it will need to be overridden when using certain applications.
Additional information about this change, including instructions for
making this change locally in advance of 5.0.4 (recommended), can be
found at:
http://wiki.debian.org/mmap_min_addr

Several vulnerabilities have been discovered in the Linux kernel that
may lead to a denial of service, sensitive memory leak or privilege
escalation.  The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2009-3228

Eric Dumazet reported an instance of uninitialized kernel memory
in the network packet scheduler. Local users may be able to
exploit this issue to read the contents of sensitive kernel
memory.

CVE-2009-3238

Linus Torvalds provided a change to the get_random_int() function
to increase its randomness.

CVE-2009-3547

Earl Chew discovered a NULL pointer dereference issue in the
pipe_rdwr_open function which can be used by local users to gain
elevated privileges.

CVE-2009-3612

Jiri Pirko discovered a typo in the initialization of a structure
in the netlink subsystem that may allow local users to gain access
to sensitive kernel memory.

CVE-2009-3620

Ben Hutchings discovered an issue in the DRM manager for ATI Rage
128 graphics adapters. Local users may be able to exploit this
vulnerability to cause a denial of service (NULL pointer
dereference).

CVE-2009-3621

Tomoki Sekiyama discovered a deadlock condition in the UNIX domain
socket implementation. Local users can exploit this vulnerability
to cause a denial of service (system hang).

CVE-2009-3638

David Wagner reported an overflow in the KVM subsystem on i386
systems. This issue is exploitable by local users with access to
the /dev/kvm device file.

For the stable distribution (lenny), this problem has been fixed in
version 2.6.26-19lenny2.

For the oldstable distribution (etch), these problems, where
applicable, will be fixed in updates to linux-2.6 and linux-2.6.24.

We recommend that you upgrade your linux-2.6 and user-mode-linux

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201927-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1927-1 (linux-2.6)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"linux-tree-2.6.26", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-doc-2.6.26", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-patch-debian-2.6.26", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-source-2.6.26", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-manual-2.6.26", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-support-2.6.26-2", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-alpha", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-alpha-generic", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-alpha-generic", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-libc-dev", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-alpha-legacy", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-alpha-smp", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-alpha-legacy", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-alpha-smp", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-common", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-amd64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-amd64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-openvz-amd64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-amd64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-modules-2.6.26-2-xen-amd64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-openvz-amd64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-common-xen", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-amd64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-common-vserver", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-xen-amd64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-linux-system-2.6.26-2-xen-amd64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-common-openvz", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-amd64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-xen-amd64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-iop32x", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-iop32x", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-versatile", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-ixp4xx", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-versatile", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-orion5x", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-ixp4xx", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-armel", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-orion5x", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-parisc64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-parisc", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-parisc-smp", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-parisc64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-hppa", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-parisc", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-parisc64-smp", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-parisc64-smp", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-parisc-smp", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-486", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-openvz-686", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-686", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-686-bigmem", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-686", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-686", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-486", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-686-bigmem", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-686-bigmem", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-686-bigmem", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-linux-system-2.6.26-2-xen-686", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-686", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-openvz-686", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-xen-686", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-xen-686", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-i386", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-modules-2.6.26-2-xen-686", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-itanium", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-itanium", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-mckinley", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-mckinley", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-itanium", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-mckinley", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-mckinley", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-ia64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-itanium", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-powerpc64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-powerpc", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-powerpc64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-powerpc64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-powerpc-smp", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-powerpc-smp", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-powerpc64", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-powerpc", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-powerpc", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-powerpc", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-powerpc", ver:"2.6.26-19lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
