# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1922-1 (xulrunner)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66146);
 script_cve_id("CVE-2009-3274", "CVE-2009-3370", "CVE-2009-3372", "CVE-2009-3373", "CVE-2009-3374", "CVE-2009-3375", "CVE-2009-3376", "CVE-2009-3380", "CVE-2009-3382");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1922-1 (xulrunner)");

 desc = "The remote host is missing an update to xulrunner
announced via advisory DSA 1922-1.

Several remote vulnerabilities have been discovered in Xulrunner, a
runtime environment for XUL applications, such as the Iceweasel web
browser. The Common Vulnerabilities and Exposures project identifies
the following problems:

CVE-2009-3380

Vladimir Vukicevic, Jesse Ruderman, Martijn Wargers, Daniel
Banchero, David Keeler and Boris Zbarsky reported crashes in
layout engine, which might allow the execution of arbitrary code.

CVE-2009-3382

Carsten Book reported a crash in the layout engine, which might
allow the execution of arbitrary code.

CVE-2009-3376

Jesse Ruderman and Sid Stamm discovered spoofing vulnerability
in the file download dialog.

CVE-2009-3375

Gregory Fleischer discovered a bypass of the same-origin policy
using the document.getSelection() function.

CVE-2009-3374

moz_bug_r_a4 discovered a privilege escalation to Chrome status
in the XPCOM utility XPCVariant::VariantDataToJS.

CVE-2009-3373

regenrecht discovered a buffer overflow in the GIF parser, which
might lead to the execution of arbitrary code.

CVE-2009-3372

Marco C. discovered that a programming error in the proxy auto
configuration code might lead to denial of service or the
execution of arbitrary code.

CVE-2009-3274

Jeremy Brown discovered that the filename of a downloaded file
which is opened by the user is predictable, which might lead to
tricking the user into a malicious file if the attacker has local
access to the system.

CVE-2009-3370

Paul Stone discovered that history information from web forms
could be stolen.


For the stable distribution (lenny), these problems have been fixed
in version 1.9.0.15-0lenny1.

As indicated in the Etch release notes, security support for the
Mozilla products in the oldstable distribution needed to be stopped
before the end of the regular Etch security maintenance life cycle.
You are strongly encouraged to upgrade to stable or switch to a still
supported browser.

For the unstable distribution (sid), these problems have been fixed in
version 1.9.1.4-1.

We recommend that you upgrade your xulrunner packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201922-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1922-1 (xulrunner)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libmozillainterfaces-java", ver:"1.9.0.15-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9", ver:"1.9.0.15-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs1d-dbg", ver:"1.9.0.15-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs-dev", ver:"1.9.0.15-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs1d", ver:"1.9.0.15-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-dev", ver:"1.9.0.15-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-dbg", ver:"1.9.0.15-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-xpcom", ver:"1.9.0.15-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-gnome-support", ver:"1.9.0.15-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"spidermonkey-bin", ver:"1.9.0.15-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
