# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1908-1 (samba)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66054);
 script_cve_id("CVE-2009-2948", "CVE-2009-2906", "CVE-2009-2813");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1908-1 (samba)");

 desc = "The remote host is missing an update to samba
announced via advisory DSA 1908-1.

Several vulnerabilities have been discovered in samba, an implementation of
the SMB/CIFS protocol for Unix systems, providing support for cross-platform
file and printer sharing with other operating systems and more.  The Common
Vulnerabilities and Exposures project identifies the following problems:

The mount.cifs utility is missing proper checks for file permissions when
used in verbose mode.  This allows local users to partly disclose the
content of arbitrary files by specifying the file as credentials file and
attempting to mount a samba share (CVE-2009-2948).

A reply to an oplock break notification which samba doesn't expect could
lead to the service getting stuck in an infinite loop.  An attacker
can use this to perform denial of service attacks via a specially crafted
SMB request (CVE-2009-2906).

A lack of error handling in case no home diretory was configured/specified
for the user could lead to file disclosure.  In case the automated [homes]
share is enabled or an explicit share is created with that username, samba
fails to enforce sharing restrictions which results in an attacker being
able to access the file system from the root directory (CVE-2009-2813).


For the oldstable distribution (etch), this problem will be fixed soon.

For the stable distribution (lenny), this problem has been fixed in
version 2:3.2.5-4lenny7.

For the testing distribution (squeeze), this problem will be fixed soon.

For the unstable distribution (sid), this problem has been fixed in
version 2:3.4.2-1.


We recommend that you upgrade your samba packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201908-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1908-1 (samba)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"samba-doc", ver:"3.2.5-4lenny7", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.2.5-4lenny7", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-dbg", ver:"3.2.5-4lenny7", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"swat", ver:"3.2.5-4lenny7", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"winbind", ver:"3.2.5-4lenny7", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.2.5-4lenny7", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba", ver:"3.2.5-4lenny7", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbfs", ver:"3.2.5-4lenny7", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwbclient0", ver:"3.2.5-4lenny7", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-tools", ver:"3.2.5-4lenny7", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.2.5-4lenny7", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient", ver:"3.2.5-4lenny7", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-common", ver:"3.2.5-4lenny7", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbclient", ver:"3.2.5-4lenny7", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
