# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1897-1 (horde3)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(65002);
 script_cve_id("CVE-2009-3236");
 script_version ("$");
 script_name("Debian Security Advisory DSA 1897-1 (horde3)");

 desc = "The remote host is missing an update to horde3
announced via advisory DSA 1897-1.

Stefan Esser discovered that Horde, a web application framework providing
classes for dealing with preferences, compression, browser detection,
connection tracking, MIME, and more, is insufficiently validating and
escaping user provided input.  The Horde_Form_Type_image form element
allows to reuse a temporary filename on reuploads which are stored in a
hidden HTML field and then trusted without prior validation.  An attacker
can use this to overwrite arbitrary files on the system or to upload PHP
code and thus execute arbitrary code with the rights of the webserver.


For the oldstable distribution (etch), this problem has been fixed in
version 3.1.3-4etch6.

For the stable distribution (lenny), this problem has been fixed in
version 3.2.2+debian0-2+lenny1.

For the testing distribution (squeeze), this problem has been fixed in
version 3.3.5+debian0-1.

For the unstable distribution (sid), this problem has been fixed in
version 3.3.5+debian0-1.


We recommend that you upgrade your horde3 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201897-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1897-1 (horde3)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"horde3", ver:"3.1.3-4etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"horde3", ver:"3.2.2+debian0-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
