# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1895-1 (xmltooling)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64980);
 script_version ("$");
 script_name("Debian Security Advisory DSA 1895-1 (xmltooling)");

 desc = "The remote host is missing an update to xmltooling
announced via advisory DSA 1895-1.

Several vulnerabilities have been discovered in the xmltooling packages,
as used by Shibboleth:

Chris Ries discovered that decoding a crafted URL leads to a crash (and
potentially, arbitrary code execution).

Ian Young discovered that embedded NUL characters in certificate names
were not correctly handled, exposing configurations using PKIX trust
validation to impersonation attacks.

Incorrect processing of SAML metadata ignores key usage constraints.
This minor issue also needs a correction in the opensaml2 packages,
which will be provided in an upcoming stable point release (and,
before that, via stable-proposed-updates).

For the stable distribution (lenny), these problems have been fixed in
version 1.0-2+lenny1.

For the unstable distribution (sid), these problems have been fixed in
version 1.2.2-1.

We recommend that you upgrade your xmltooling packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201895-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1895-1 (xmltooling)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xmltooling-schemas", ver:"1.0-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxmltooling-doc", ver:"1.0-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxmltooling-dev", ver:"1.0-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxmltooling1", ver:"1.0-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
