# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1879-1 (silc-client/silc-toolkit)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64822);
 script_cve_id("CVE-2008-7159", "CVE-2008-7160", "CVE-2009-3051");
 script_version ("$");
 script_name("Debian Security Advisory DSA 1879-1 (silc-client/silc-toolkit)");

 desc = "The remote host is missing an update to silc-client/silc-toolkit
announced via advisory DSA 1879-1.

Several vulnerabilities have been discovered in the software suite for the
SILC protocol, a network protocol designed to provide end-to-end security
for conferencing services.  The Common Vulnerabilities and Exposures
project identifies the following problems:

An incorrect format string in sscanf() used in the ASN1 encoder to scan an
OID value could overwrite a neighbouring variable on the stack as the
destination data type is smaller than the source type on 64-bit. On 64-bit
architectures this could result in unexpected application behaviour or even
code execution in some cases (CVE-2008-7159).

Various format string vulnerabilities when handling parsed SILC messages
allow an attacker to execute arbitrary code with the rights of the victim
running the SILC client via crafted nick names or channel names containing
format strings (CVE-2009-3051).

An incorrect format string in a sscanf() call used in the HTTP server
component of silcd could result in overwriting a neighbouring variable on
the stack as the destination data type is smaller than the source type on
64-bit.  An attacker could exploit this by using crafted Content-Length
header values resulting in unexpected application behaviour or even code
execution in some cases (CVE-2008-7160).


silc-server doesn't need an update as it uses the shared library provided
by silc-toolkit. silc-client/silc-toolkit in the oldstable distribution
(etch) is not affected by this problem.

For the stable distribution (lenny), this problem has been fixed in
version 1.1.7-2+lenny1 of silc-toolkit and in version 1.1.4-1+lenny1
of silc-client.

For the testing distribution (squeeze), this problem will be fixed soon.

For the unstable distribution (sid), this problem has been fixed in
version 1.1.10-1 of silc-toolkit and version 1.1-2 of silc-client
(using libsilc from silc-toolkit since this upload).

We recommend that you upgrade your silc-toolkit/silc-client packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201879-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1879-1 (silc-client/silc-toolkit)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libsilc-1.1-2-dbg", ver:"1.1.7-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irssi-plugin-silc", ver:"1.1.4-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsilc-1.1-2-dev", ver:"1.1.7-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsilc-1.1-2", ver:"1.1.7-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"silc", ver:"1.1.4-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
