# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1878-2 (devscripts)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64867);
 script_cve_id("CVE-2009-2946");
 script_version ("$");
 script_name("Debian Security Advisory DSA 1878-2 (devscripts)");

 desc = "The remote host is missing an update to devscripts
announced via advisory DSA 1878-2.

This update corrects regressions introduced by the devscripts security
update, DSA-1878-1.  The original announcement was:

Raphael Geissert discovered that uscan, a program to check for
availability of new source code versions which is part of the
devscripts package, runs Perl code downloaded from potentially
untrusted sources to implement its URL and version mangling
functionality.  This update addresses this issue by reimplementing the
relevant Perl operators without relying on the Perl interpreter,
trying to preserve backwards compatibility as much as possible.

For the old stable distribution (etch), this problem has been fixed in
version 2.9.26etch5.

For the stable distribution (lenny), this problem has been fixed in
version 2.10.35lenny7.

For the unstable distribution (sid), this problem will be fixed in
version 2.10.55.

We recommend that you upgrade your devscripts package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201878-2

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1878-2 (devscripts)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"devscripts", ver:"2.9.26etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"devscripts", ver:"2.10.35lenny7", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
