# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1859-1 (libxml2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64638);
 script_cve_id("CVE-2009-2416", "CVE-2009-2414");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1859-1 (libxml2)");

 desc = "The remote host is missing an update to libxml2
announced via advisory DSA 1859-1.

Rauli Kaksonen, Tero Rontti and Jukka Taimisto discovered several
vulnerabilities in libxml2, a library for parsing and handling XML data
files, which can lead to denial of service conditions or possibly arbitrary
code execution in the application using the library.  The Common
Vulnerabilities and Exposures project identifies the following problems:

An XML document with specially-crafted Notation or Enumeration attribute
types in a DTD definition leads to the use of a pointers to memory areas
which have already been freed (CVE-2009-2416).

Missing checks for the depth of ELEMENT DTD definitions when parsing
child content can lead to extensive stack-growth due to a function
recursion which can be triggered via a crafted XML document (CVE-2009-2414).


For the oldstable distribution (etch), this problem has been fixed in
version 2.6.27.dfsg-6+etch1.

For the stable distribution (lenny), this problem has been fixed in
version 2.6.32.dfsg-5+lenny1.

For the testing (squeeze) and unstable (sid) distribution, this problem
will be fixed soon.


We recommend that you upgrade your libxml2 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201859-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1859-1 (libxml2)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libxml2-doc", ver:"2.6.27.dfsg-6+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.6.27.dfsg-6+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-libxml2", ver:"2.6.27.dfsg-6+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-dbg", ver:"2.6.27.dfsg-6+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-utils", ver:"2.6.27.dfsg-6+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2", ver:"2.6.27.dfsg-6+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-doc", ver:"2.6.32.dfsg-5+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.6.32.dfsg-5+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-dbg", ver:"2.6.32.dfsg-5+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2", ver:"2.6.32.dfsg-5+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-utils", ver:"2.6.32.dfsg-5+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-libxml2", ver:"2.6.32.dfsg-5+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
