# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1838-1 (pulseaudio)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64476);
 script_cve_id("CVE-2009-1894");
 script_version ("$");
 script_name("Debian Security Advisory DSA 1838-1 (pulseaudio)");

 desc = "The remote host is missing an update to pulseaudio
announced via advisory DSA 1838-1.

Tavis Ormandy and Julien Tinnes discovered that the pulseaudio daemon
does not drop privileges before re-executing itself, enabling local
attackers to increase their privileges.

The old stable distribution (etch) is not affected by this issue.

For the stable distribution (lenny), this problem has been fixed in
version 0.9.10-3+lenny1.

For the unstable distribution (sid), this problem will be fixed soon.

We recommend that you upgrade your pulseaudio packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201838-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1838-1 (pulseaudio)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"pulseaudio-module-zeroconf", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-hal-dbg", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse0", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-gconf-dbg", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulsecore5-dbg", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-x11", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-jack", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-lirc", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-esound-compat", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-hal", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-mainloop-glib0-dbg", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-lirc-dbg", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-mainloop-glib0", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-esound-compat-dbg", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-x11-dbg", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-utils-dbg", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-browse0-dbg", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-browse0", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse0-dbg", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-utils", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-zeroconf-dbg", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-dev", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-gconf", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulsecore5", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-jack-dbg", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-dbg", ver:"0.9.10-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
