# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1835-1 (tiff)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64422);
 script_cve_id("CVE-2009-2285", "CVE-2009-2347");
 script_version ("$");
 name = "Debian Security Advisory DSA 1835-1 (tiff)";
 script_name(name);

 desc = "The remote host is missing an update to tiff
announced via advisory DSA 1835-1.

Several vulnerabilities have been discovered in the library for the
Tag Image File Format (TIFF). The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2009-2285

It was discovered that malformed TIFF images can lead to a crash
in the decompression code, resulting in denial of service.

CVE-2009-2347

Andrea Barisani discovered several integer overflows, which
can lead to the execution of arbitrary code if malformed
images are passed to the rgb2ycbcr or tiff2rgba tools.

For the old stable distribution (etch), these problems have been fixed
in version 3.8.2-7+etch3.

For the stable distribution (lenny), these problems have been fixed in
version 3.8.2-11.2.

For the unstable distribution (sid), these problems will be fixed soon.

We recommend that you upgrade your tiff packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201835-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1835-1 (tiff)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libtiff4-dev", ver:"3.8.2-7+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiffxx0c2", ver:"3.8.2-7+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff4", ver:"3.8.2-7+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-tools", ver:"3.8.2-7+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-opengl", ver:"3.8.2-7+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-doc", ver:"3.8.2-11.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff4", ver:"3.8.2-11.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff4-dev", ver:"3.8.2-11.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-opengl", ver:"3.8.2-11.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiffxx0c2", ver:"3.8.2-11.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-tools", ver:"3.8.2-11.2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
