# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1807-1 (cyrus-sasl2, cyrus-sasl2-heimdal)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64109);
 script_cve_id("CVE-2009-0688");
 script_version ("$");
 name = "Debian Security Advisory DSA 1807-1 (cyrus-sasl2, cyrus-sasl2-heimdal)";
 script_name(name);

 desc = "The remote host is missing an update to cyrus-sasl2, cyrus-sasl2-heimdal
announced via advisory DSA 1807-1.

James Ralston discovered that the sasl_encode64() function of cyrus-sasl2,
a free library implementing the Simple Authentication and Security Layer,
suffers from a missing null termination in certain situations.  This causes
several buffer overflows in situations where cyrus-sasl2 itself requires
the string to be null terminated which can lead to denial of service or
arbitrary code execution.

Important notice (Quoting from US-CERT):
While this patch will fix currently vulnerable code, it can cause
non-vulnerable existing code to break. Here's a function prototype from
include/saslutil.h to clarify my explanation:

/* base64 encode
* in -- input data
* inlen -- input data length
* out -- output buffer (will be NUL terminated)
* outmax -- max size of output buffer
* result:
* outlen -- gets actual length of output buffer (optional)
*
* Returns SASL_OK on success, SASL_BUFOVER if result won't fit
*/
LIBSASL_API int sasl_encode64(const char *in, unsigned inlen,
char *out, unsigned outmax,
unsigned *outlen);

Assume a scenario where calling code has been written in such a way that it
calculates the exact size required for base64 encoding in advance, then
allocates a buffer of that exact size, passing a pointer to the buffer into
sasl_encode64() as *out. As long as this code does not anticipate that the
buffer is NUL-terminated (does not call any string-handling functions like
strlen(), for example) the code will work and it will not be vulnerable.

Once this patch is applied, that same code will break because sasl_encode64()
will begin to return SASL_BUFOVER.


For the oldstable distribution (etch), this problem will be fixed soon.

For the stable distribution (lenny), this problem has been fixed in
version 2.1.22.dfsg1-23+lenny1 of cyrus-sasl2 and cyrus-sasl2-heimdal.

For the testing distribution (squeeze), this problem will be fixed soon.

For the unstable distribution (sid), this problem has been fixed in
version 2.1.23.dfsg1-1 of cyrus-sasl2 and cyrus-sasl2-heimdal.


We recommend that you upgrade your cyrus-sasl2/cyrus-sasl2-heimdal packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201807-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1807-1 (cyrus-sasl2, cyrus-sasl2-heimdal)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cyrus-sasl2-doc", ver:"2.1.22.dfsg1-23+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsasl2-modules-otp", ver:"2.1.22.dfsg1-23+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-sasl2-dbg", ver:"2.1.22.dfsg1-23+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsasl2-2", ver:"2.1.22.dfsg1-23+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsasl2-modules-gssapi-heimdal", ver:"2.1.22.dfsg1-23+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsasl2-modules", ver:"2.1.22.dfsg1-23+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsasl2-modules-sql", ver:"2.1.22.dfsg1-23+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsasl2-modules-ldap", ver:"2.1.22.dfsg1-23+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sasl2-bin", ver:"2.1.22.dfsg1-23+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsasl2-modules-gssapi-mit", ver:"2.1.22.dfsg1-23+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsasl2-dev", ver:"2.1.22.dfsg1-23+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-sasl2-heimdal-dbg", ver:"2.1.22.dfsg1-23+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
