# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1782-1 (mplayer)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63935);
 script_cve_id("CVE-2009-0385", "CVE-2008-4866", "CVE-2008-5616");
 script_version ("$");
 name = "Debian Security Advisory DSA 1782-1 (mplayer)";
 script_name(name);

 desc = "The remote host is missing an update to mplayer
announced via advisory DSA 1782-1.


Several vulnerabilities have been discovered in mplayer, a movie player
for Unix-like systems. The Common Vulnerabilities and Exposures project
identifies the following problems:


CVE-2009-0385

It was discovered that watching a malformed 4X movie file could lead to
the execution of arbitrary code.

CVE-2008-4866

It was discovered that multiple buffer overflows could lead to the
execution of arbitrary code.

CVE-2008-5616

It was discovered that watching a malformed TwinVQ file could lead to
the execution of arbitrary code.


For the oldstable distribution (etch), these problems have been fixed
in version 1.0~rc1-12etch7.

For the stable distribution (lenny), mplayer links against
ffmpeg-debian.

For the testing distribution (squeeze) and the unstable distribution
(sid), mplayer links against ffmpeg-debian.


We recommend that you upgrade your mplayer packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201782-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1782-1 (mplayer)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mplayer-doc", ver:"1.0~rc1-12etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mplayer", ver:"1.0~rc1-12etch7", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
