# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1775-1 (php-json-ext)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63885);
 script_cve_id("CVE-2009-1271");
 script_version ("$");
 name = "Debian Security Advisory DSA 1775-1 (php-json-ext)";
 script_name(name);

 desc = "The remote host is missing an update to php-json-ext
announced via advisory DSA 1775-1.

It was discovered that php-json-ext, a JSON serialiser for PHP, is
prone to a denial of service attack, when receiving a malformed string
via the json_decode function.

For the oldstable distribution (etch), this problem has been fixed in
version 1.2.1-3.2+etch1.

The stable distribution (lenny) does not contain a separate php-json-ext
package, but includes it in the php5 packages, which will be fixed soon.

The testing distribution (squeeze) and the unstable distribution (sid)
do not contain a separate php-json-ext package, but include it in the
php5 packages.

We recommend that you upgrade your php-json-ext packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201775-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1775-1 (php-json-ext)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php4-json", ver:"1.2.1-3.2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-json", ver:"1.2.1-3.2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
