# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1773-1 (cups)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63843);
 script_cve_id("CVE-2009-0163");
 script_version ("$");
 name = "Debian Security Advisory DSA 1773-1 (cups)";
 script_name(name);

 desc = "The remote host is missing an update to cups
announced via advisory DSA 1773-1.

It was discovered that the imagetops filter in cups, the Common UNIX
Printing System, is prone to an integer overflow when reading malicious
TIFF images.

For the stable distribution (lenny), this problem has been fixed in
version 1.3.8-1lenny5.

For the oldstable distribution (etch), this problem has been fixed in
version 1.2.7-4etch7.

For the testing distribution (squeeze) and the unstable distribution
(sid), this problem will be fixed soon.

We recommend that you upgrade your cups packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201773-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1773-1 (cups)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libcupsys2-gnutls10", ver:"1.2.7-4etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-common", ver:"1.2.7-4etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-bsd", ver:"1.2.7-4etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2-dev", ver:"1.2.7-4etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-dbg", ver:"1.2.7-4etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2", ver:"1.2.7-4etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-client", ver:"1.2.7-4etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys", ver:"1.2.7-4etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsimage2", ver:"1.2.7-4etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsimage2-dev", ver:"1.2.7-4etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-dbg", ver:"1.3.8-1lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2-dev", ver:"1.3.8-1lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-bsd", ver:"1.3.8-1lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-common", ver:"1.3.8-1lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups-common", ver:"1.3.8-1lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2", ver:"1.3.8-1lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys", ver:"1.3.8-1lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-client", ver:"1.3.8-1lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsimage2", ver:"1.3.8-1lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups-dbg", ver:"1.3.8-1lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups-bsd", ver:"1.3.8-1lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups", ver:"1.3.8-1lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcups2-dev", ver:"1.3.8-1lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups-client", ver:"1.3.8-1lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcups2", ver:"1.3.8-1lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsimage2-dev", ver:"1.3.8-1lenny5", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
