# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1769-1 (openjdk-6)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63797);
 script_cve_id("CVE-2006-2426", "CVE-2009-0581", "CVE-2009-0723", "CVE-2009-0733", "CVE-2009-0793", "CVE-2009-1093", "CVE-2009-1094", "CVE-2009-1095", "CVE-2009-1096", "CVE-2009-1097", "CVE-2009-1098", "CVE-2009-1101");
 script_version ("$");
 name = "Debian Security Advisory DSA 1769-1 (openjdk-6)";
 script_name(name);

 desc = "The remote host is missing an update to openjdk-6
announced via advisory DSA 1769-1.

Several vulnerabilities have been identified in OpenJDK, an
implementation of the Java SE platform.

Creation of large, temporary fonts could use up available disk space,
leading to a denial of service condition (CVE-2006-2426).

Several vulnerabilities existed in the embedded LittleCMS library,
exploitable through crafted images: a memory leak, resulting in a
denial of service condition (CVE-2009-0581), heap-based buffer
overflows, potentially allowing arbitrary code execution
(CVE-2009-0723, CVE-2009-0733), and a null-pointer dereference,
leading to denial of service (CVE-2009-0793).

The LDAP server implementation (in com.sun.jdni.ldap) did not properly
close sockets if an error was encountered, leading to a
denial-of-service condition (CVE-2009-1093).

The LDAP client implementation (in com.sun.jdni.ldap) allowed
malicious LDAP servers to execute arbitrary code on the client
(CVE-2009-1094).

The HTTP server implementation (sun.net.httpserver) contained an
unspecified denial of service vulnerability (CVE-2009-1101).

Several issues in Java Web Start have been addressed (CVE-2009-1095,
CVE-2009-1096, CVE-2009-1097, CVE-2009-1098).  The Debian packages
currently do not support Java Web Start, so these issues are not
directly exploitable, but the relevant code has been updated
nevertheless.

For the stable distribution (lenny), these problems have been fixed in
version 9.1+lenny2.

We recommend that you upgrade your openjdk-6 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201769-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1769-1 (openjdk-6)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"openjdk-6-doc", ver:"6b11-9.1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openjdk-6-jre-lib", ver:"6b11-9.1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openjdk-6-source", ver:"6b11-9.1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openjdk-6-jdk", ver:"6b11-9.1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openjdk-6-jre", ver:"6b11-9.1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openjdk-6-jre-headless", ver:"6b11-9.1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openjdk-6-dbg", ver:"6b11-9.1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openjdk-6-demo", ver:"6b11-9.1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
