# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 174-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53429);
 script_version ("$");
 name = "Debian Security Advisory DSA 174-1 (heartbeat)";
 script_name(name);

 desc = "The remote host is missing an update to heartbeat
announced via advisory DSA 174-1.

Nathan Wallwork discovered a buffer overflow in heartbeat, a subsystem
for High-Availability Linux.  A remote attacker could send a specially
crafted TCP packet that overflows a buffer, leaving heartbeat to
execute arbitrary code as root.

This problem has been fixed in version 0.4.9.0l-7.2 for the current
stable distribution (woody) and version 0.4.9.2-1 for the unstable
distribution (sid).  The old stable distribution (potato) doesn't
contain a heartbeat package.

We recommend that you upgrade your heartbeat package immediately if


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20174-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 174-1 (heartbeat)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ldirectord", ver:"0.4.9.0l-7.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heartbeat", ver:"0.4.9.0l-7.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libstonith-dev", ver:"0.4.9.0l-7.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libstonith0", ver:"0.4.9.0l-7.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"stonith", ver:"0.4.9.0l-7.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
