# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1693-1 (phppgadmin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63065);
 script_cve_id("CVE-2007-2865", "CVE-2007-5728", "CVE-2008-5587");
 script_version ("$");
 name = "Debian Security Advisory DSA 1693-1 (phppgadmin)";
 script_name(name);

 desc = "The remote host is missing an update to phppgadmin
announced via advisory DSA 1693-1.

Several remote vulnerabilities have been discovered in phpPgAdmin, a tool
to administrate PostgreSQL database over the web. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2007-2865

Cross-site scripting vulnerability allows remote attackers to inject
arbitrary web script or HTML via the server parameter.

CVE-2007-5728

Cross-site scripting vulnerability allows remote attackers to inject
arbitrary web script or HTML via PHP_SELF.

CVE-2008-5587

Directory traversal vulnerability allows remote attackers to read
arbitrary files via _language parameter.

For the stable distribution (etch), these problems have been fixed in
version 4.0.1-3.1etch1.

For the unstable distribution (sid), these problems have been fixed in
version 4.2.1-1.1.

We recommend that you upgrade your phppgadmin package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201693-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1693-1 (phppgadmin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"phppgadmin", ver:"4.0.1-3.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
